gstruct = 
{
	next_line_id = "";
	next_index = 1;
	conv_choices = {};	-- the current active choice table
	cc_pile = {};		-- push_choices_to and pull_choices_from use this to hold other choice tables
};

function goto(convname, index)
	if index == nil then index = 1; end;
	if index == 0 then index = 1; end;
	
	xprint("SUPERCONV>>>>>>>>>goto[", convname, ":", index, "]");
	gstruct.next_line_id = convname;
	gstruct.next_index = index;
end;

function on( ... )
	xprint("COMMAND ON");
	table.foreachi( arg, 
		function( i, choicename )
			xprint("SUPERCONV>>>>>>>>>on[", choicename, "]");
			gstruct.conv_choices[choicename] = true;
		end
	);
end;

function off( ... )
	xprint("COMMAND OFF");
	table.foreachi( arg, 
		function( i, choicename )
			xprint("SUPERCONV>>>>>>>>>off[", choicename, "]");
			gstruct.conv_choices[choicename] = false;
		end
	);
end;

function on_if(gamevar, ... )
	if game:Get(gamevar) == 1 then
		table.foreachi( arg, 
			function( i, choicename )
				xprint("SUPERCONV>>>>>>>>>on_if[", choicename, "]");
				gstruct.conv_choices[choicename] = true;
			end
		);
	end
end

function on_unless(gamevar, choicename)
	if not (game:Get(gamevar) == 1) then
		table.foreachi( arg, 
			function( i, choicename )
				xprint("SUPERCONV>>>>>>>>>on_unless[", choicename, "]");
				gstruct.conv_choices[choicename] = true;
			end
		);
	end
end

function on_once( ... )
	xprint("COMMAND ON_ONCE");
	table.foreachi( arg, 
		function( i, choicename )
			xprint("SUPERCONV>>>>>>>>>on_once[", choicename, "]");
			if game:Get(choicename) ~= 1 then
				on(choicename);
			end
		end
	);
end

function off_once( ... )
	xprint("COMMAND OFF_ONCE");
	table.foreachi( arg, 
		function( i, choicename )
			xprint("SUPERCONV>>>>>>>>>off_once[", choicename, "]");
			game:Set(choicename, 1);
			off(choicename);
		end
	);
end

function setflag(gamevar)
	game:Set(gamevar, 1);
end;

function clearflag(gamevar)
	game:Set(gamevar, 0);
end;

function clear_choices()
	xprint("SUPERCONV>>>>>>>>>clear_choices()");
	gstruct.conv_choices = {};
end;

-- save conv_choices as table
function push_choices_to(tablename)
	xprint("SUPERCONV>>>>>>>>>push_choices_to(", tablename, ")");
	gstruct.cc_pile[tablename] = gstruct.conv_choices;
	gstruct.conv_choices = {};
end

-- recover conv_choices from table
function pull_choices_from(tablename)
	xprint("SUPERCONV>>>>>>>>>pull_choices_from(", tablename, ")");
	gstruct.conv_choices = gstruct.cc_pile[tablename];
	gstruct.cc_pile[tablename] = {};
end

-- set bg conversation speed
function set_bg_speed(speed)
	xprint("SUPERCONV>>>>set_bg_speed(", speed, ")");
	gstruct.speed = speed;
end

function lookup_speaker(oldspeaker, line_id)
	if (oldspeaker == "" or oldspeaker == nil) and speakertable then
		oldspeaker = speakertable[line_id];
		
		if type(oldspeaker) == "table" then
		
			-----------------------------------
			-- this line is in the form
			-- speakertable.lineid = { "PETRA", emotion = "emotion" }
			-----------------------------------
			
			local sname = oldspeaker[1];			-- get the NAME
			local emotion = oldspeaker.emotion;		-- get the EMOTION
			if emotion then
				scene[sname]:SetEmotion(emotion);	-- set the ACTOR to that EMOTION
			end;
			
			oldspeaker = sname;	-- return the NAME
			
		end;
		
	end;
	return oldspeaker;
end

-- for testing results of grabspeechline
function got_no_line(line_raw)
	return line_raw == "" or line_raw == nil;
end

--
-- actor is needed so the MQ framework can signal the proper actor when the choice is made
--   so that the yield(RESUME.ON_SIGNAL) will work
-- conversation_name is a string naming the first line to do
--
function run_super_conversation(default_actor, conversation_name)

	scene:SetMode(MODE.DIALOG);
	local struct = {};

	-- clear the conversation result
	game:SetString("conv", "");

	-- clear the conversation choice tree
	struct.conv_choices = {};
	struct.cc_pile = {};
	
	-- prepare the first line
	struct.next_line_id = conversation_name;
	struct.next_index = 1;
	
	sfx:AdjustBGVoxVolume(0.7);
	
	while true do
	
		-- Create the numbered line id "conv_introduction_1"
		xprint("SUPERCONV[", struct.next_line_id, ":", struct.next_index, "]");
		local cur_line_id = struct.next_line_id .. "_" .. struct.next_index;

		-- pull in the speaker and speech for this line
		local speaker;
		local line_raw;		
		speaker, line_raw = scene:grabspeechline(cur_line_id);
		
		-- got no line?
		
		-- added 1/August/2008: Check for conv_whatever_01
		if got_no_line(line_raw) then 
			if struct.next_index < 10 then -- try it with a leading zero
				cur_line_id = struct.next_line_id .. "_0" .. struct.next_index;
				speaker, line_raw = scene:grabspeechline(cur_line_id);
				if not got_no_line(line_raw) then
					xprint("Using fallback conv [", cur_line_id, "]");
				end
			end
		end;

		-- STILL got no line?
		if got_no_line(line_raw) then 
			if struct.next_index == 1 then -- try it with no-number
				cur_line_id = struct.next_line_id;
				speaker, line_raw = scene:grabspeechline(cur_line_id);
			end
		end;
		
		speaker = lookup_speaker(speaker, cur_line_id);
		
		if speaker == "" or speaker == nil then
			speaker = default_actor.name;
		end;	

		-- debug output
		xprint("speaker =[", speaker, "] line_raw = [", line_raw, "]");
						
		-- anticipate the next line		
		struct.next_index = struct.next_index + 1;

		if string.find(cur_line_id, "choice", 1, true) == 1 then
			xprint("This is a choice!!");
			
			local total_line = "";
			
			local speaker = "UNKNOWN";
			
			-- build a table fer sortin' [just of true choice keys]
			
			local choicecount = 0;
			local sorttable = {}
			for k, v in pairs(struct.conv_choices) do
				if v == true then
					table.insert(sorttable, k);
					choicecount = choicecount + 1;
				end
			end
	
			local user_choice = "";
			
			if choicecount == 0 then
				xprint("run_super_conversation exits: NO CHOICES");
				scene:SetMode(MODE.FOLLOWCLICKS);
				return;
			elseif choicecount == 1 then
				table.sort(sorttable);
				user_choice = sorttable[1];
				xprint("run_super_conversation ONE CHOICE:", user_choice);
			else
				-- more than one choice
				-- sort the table
				table.sort(sorttable);
				
				-- for every indexed key in sorttable
				for i,k in ipairs(sorttable) do
					-- look up the original v from conv_choices
					v = struct.conv_choices[k];
					
					xprint("Choice[", k, "] state ", v);
					if v == true then

						local line_raw;
						speaker, line_raw = scene:grabspeechline(k);
						
						-- added 1/August/2008: Check for choice_whatever_01
						if got_no_line(line_raw) then 
							xprint("got no line for choice [", k, "]");
							-- does it end in a single _digit
							if string.find(k, '_%d', -2) then
							
								-- try it as "_01" instead of "_1"
								
								local test_k = string.sub(k, 1, -2) .. "0" .. string.sub(k, -1);
								local test_speaker, test_line_raw = scene:grabspeechline(test_k);
								
								if not got_no_line(test_line_raw) then
									-- accept the use of choice_whatever_01
									
									xprint("Using fallback choice [", test_k, "]");
									
									k = test_k;
									speaker = test_speaker;
									line_raw = test_line_raw;
								else
									xprint("also got no line for choice [", test_k, "]");
								end
							else
								xprint("Didn't find a _# pattern");
							end
						end
						
						speaker = lookup_speaker(speaker, k);
				
						xprint("SPEAKER[", speaker, "] STRING[", line_raw, "]");
						
						special = "<a id = \""
									.. k					-- add the answername
									.. "\" color = 'ff00ff'>"
									.. line_raw				-- add the visible string
									.. "\n</a>";
									
						total_line = total_line..special;
						
					end;	-- if choice is ON
				end; -- for all known choices
				
				scene:ConversationMode(true);
				scene:ConversationMode(default_actor.this);
				default_actor:SayRaw(total_line);
				coroutine.yield(RESUME.ON_CHOICE, RESUME.ON_ABORT);
				default_actor:Say("");
				scene:ConversationMode(false);
				user_choice = game:GetString("conv");
			end
			
			if dialogtable and dialogtable[user_choice] then
				xprint("SUPERCONV COMMAND:");
				gstruct = struct;
				dialogtable[user_choice]();
				gstruct = {};
			else
				-- xprint("VERY STRANGE; NO SCRIPT WAS GIVEN FOR THE CHOICE");
				-- this must be the end of the conversation
				xprint("run_super_conversation exits with no-script choice ", user_choice);
				scene:SetMode(MODE.FOLLOWCLICKS);
				return;
			end
			
		else -- not a choice!
			-- if the CURRENT line has a handler then run it now
			if dialogtable and dialogtable[cur_line_id] then
				xprint("SUPERCONV COMMAND:");
				gstruct = struct;
				dialogtable[cur_line_id]();
				gstruct = {};
			end
		
			if (line_raw == "[*]") then
				-- skip this line
			elseif line_raw == "" or line_raw == nil then 
				xprint("Super conversation over on line ", cur_line_id);
				break; 
			else
				sfx:PlayVox(cur_line_id, line_raw);
				line_raw = "<i>" .. string.upper(line_raw) .. "</i>";
				scene[speaker]:SayRaw(line_raw);
				safe_talk_wait(scene[speaker]);
				scene[speaker]:Say("");
			end
		end
		
--		if scene:IsConversationAborted() then
--			xprint("conversation aborted");
--			break;
--		end
	end
	
	xprint("run_super_conversation exits");
	sfx:KillVox();

	sfx:AdjustBGVoxVolume(1.0);
	
	scene:SetMode(MODE.FOLLOWCLICKS);
	
	return game:GetString("conv");
	
end -- run_conversation

run_generic_conversation = run_super_conversation

function run_bg_conversation(default_actor, conversation_name, speed)
	
	local struct = {};
	struct.next_line_id = conversation_name;
	struct.next_index = 1;
	if speed then
		struct.speed = speed;
	else 
		struct.speed = 200;	-- default speed
	end;
	struct.conv_choices = {};
	struct.cc_pile = {};
	
	while true do
		-- Create the numbered line id "conv_introduction_1"
		xprint("BGCONV[", struct.next_line_id, ":", struct.next_index, "]");
		
		local cur_line_id = struct.next_line_id .. "_" .. struct.next_index;

		-- pull in the speaker and speech for this line
		local speaker;
		local line_raw;		
		speaker, line_raw = scene:grabspeechline(cur_line_id);
		
		-- added 1/August/2008: Check for conv_whatever_01
		if got_no_line(line_raw) then 
			if struct.next_index < 10 then -- try it with a leading zero
				cur_line_id = struct.next_line_id .. "_0" .. struct.next_index;
				speaker, line_raw = scene:grabspeechline(cur_line_id);
			end
		end;
		
		-- got no line?
		if got_no_line(line_raw) then 
			if struct.next_index == 1 then -- try it with no-number
				cur_line_id = struct.next_line_id;
				speaker, line_raw = scene:grabspeechline(cur_line_id);
			end
		end;

		speaker = lookup_speaker(speaker, cur_line_id);
		
		if speaker == "" or speaker == nil then
			speaker = default_actor.name;
		end;	

		-- debug output
		xprint("speaker =[", speaker, "] line_raw = [", line_raw, "]");
						
		-- anticipate the next line		
		struct.next_index = struct.next_index + 1;
		
		-- if the CURRENT line has a handler then run it now
		if dialogtable and dialogtable[cur_line_id] then
			xprint("BGCONV COMMAND:");
			gstruct = struct;
			dialogtable[cur_line_id]();
			gstruct = nil;
		end

		if (line_raw == "[*]") then
			-- skip this line
		elseif line_raw == "" or line_raw == nil then 
			xprint("BG conversation over");
			break; 
		else
			sfx:PlayBGVox(cur_line_id, line_raw);
			scene[speaker]:SayRaw(line_raw);
			local why = coroutine.yield(RESUME.ON_BGVOXDONE);
			scene[speaker]:Say("");
			
			if why == RESUME.ON_BGVOXDONE then
				-- wait for the callback to make SURE it's done before cutting off sound
				coroutine.yield(RESUME.ON_BGVOXQUITEDONE);
			end
		end
		
--		if scene:IsConversationAborted() then
--			xprint("conversation aborted");
--			break;
--		end

	end
	
end -- run_bg_conversation
